import myAlertifyDialog from '../../components/myAlertifyDialog.js'
import Swiper from '../plugins/swiper/swiper-bundle.esm.browser.min.js'
import currency from '../plugins/currency.es.js'
import { DateTime, Duration, FixedOffsetZone, IANAZone, Info, Interval, InvalidZone, Settings, SystemZone, VERSION, Zone } from '../plugins/luxon.js'
import ItemModel from '../../model/stock.js';
import { Org } from '../../shared/helpers.js';

const CEDIS = val => currency(val, { symbol: '¢', decimal: '.', thousand: ',' });

var localeEn = {
    days: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
    daysShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
    daysMin: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
    months: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
    monthsShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    today: 'Today',
    clear: 'Clear',
    dateFormat: 'MM/dd/yyyy',
    timeFormat: 'HH:mm aa',
    firstDay: 0
}

const activeUser = localStorage.getItem('authUser') && {
    id: JSON.parse(localStorage.getItem('authUser'))['id'], 
    name: JSON.parse(localStorage.getItem('authUser'))['name'],
    role: JSON.parse(localStorage.getItem('authUser'))['role'],
    // rights: JSON.parse(localStorage.getItem('authUser'))['rights'],
    stores: JSON.parse(localStorage.getItem('authUser'))['stores'],
    photo: JSON.parse(localStorage.getItem('authUser'))['photo'],
}

const MAPBOX_ACCESS_TOKEN = 'pk.eyJ1Ijoic29mdGl0Z2giLCJhIjoiY2s4eHl6b2txMDBlMjNlbGNwMGZxZjYwcyJ9.9sJ8qq0zfKmQba0egzorfA';

const validateEmail = email => {
    var re = /\S+@\S+\.\S+/;
    return re.test(email);
}

var soundsDir = params => new Audio(params.path ? `${params.path}/${params.res}` : `../assets/tones/${params.res}`), 
    appSounds = { definite: soundsDir({res: 'definite.mp3'}), oringz: soundsDir({res: '/oringz.mp3'}), martian_gun: soundsDir({res: '/martian-gun.mp3'}), pull_out: soundsDir({res: 'pull-out.mp3'}), attention_alert: soundsDir({res: 'attention_alert.mp3'}), removed_tone: soundsDir({res: '/oringz.mp3'}) }

const ENDPOINTS = {
    org: `/config/crud.php?organization&pop`,
    taxes: `/config/crud.php?taxes&pop`
}

class SystemPrefs{
    static pop = async() => {
        return await (await fetch(`/config/crud.php?presets&pop`)).json();
    }
    static update = async (module, pref, value) => {
        // console.log(module, pref, value)
        let req = await $.post(`/config/crud.php?prefs&set`, { module, pref, value }, resp => resp, 'json');
        return req;
    }
}

const resp = await (await fetch(`../config/crud.php?prefs&pop`)).json(), myTransCodePrefix = 'POS'
// myTransCodePrefix = JSON.parse(resp.data[1].pref).code.prefix

const thousandsSeperator = val => val && val.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2});

const QIHRF = (qty, priceLabel, dim) => {
    // console.log(qty, priceLabel, dim);
    // priceLabel = priceLabel.toUpperCase()
    // return (dim >= 1 && qty < 2 ? `1 ${priceLabel}` : `${(qty > 1 ?  `${qty} ${pluralize(priceLabel)}` : `${dim < 1 ? '' : 1} ${priceLabel}`)}`);
    return (dim < 1 && qty < 2) ? priceLabel : (dim > 0 && qty == 1) ? `1 ${priceLabel}` : `${qty} ${pluralize(priceLabel)}`;
}

class Notif{
    static show(params){
        $.notify.addStyle(params.styleName, {
            html: `
                    <div>
                        <div class="clearfix">
                            <div class="title" data-notify-html="title"/>
                            <div class="buttons">
                                ${params.buttons ? params.buttons : ''}
                            </div>
                        </div>
                    </div>
            `,
            classes: {
                base: {
                    "white-space": "nowrap",
                    "background-color": params.bgColor ?? "#f44336",
                    "padding": params.padding ?? "5px",
                    "text-align": params.textAlign ?? "left",
                    "font-family": params.fontFamily ?? "verdana",
                    "color": params.color ?? "#fff",
                    "border-radius": params.borderRadius ?? "5px",
                    "box-shadow": params.boxShadow ?? "0 0 10px rgba(0,0,0,0.5)",
                },
                default: {
                    "background-color": "#f7f7f7",
                    "color": "#000"
                },
                inverse: {
                    "background-color": "#292b2c",
                    "color": "#fff"
                },
                primary: {
                    "background-color": "#Primary",
                    "color": "#fff"
                },
                success: {
                    "background-color": "#5cb85c",
                    "color": "#fff"
                },
                info: {
                    "background-color": "#5bc0de",
                    "color": "#fff"
                },
                warning: {
                    "background-color": "#fcba03",
                    "color": "#000"
                },
                danger: {
                    "background-color": "#d9534f",
                    "color": "#fff"
                }
            }
        });
        params.el.notify(
            {
                title: params.title
            }, 
            { 
                style: params.styleName, 
                className: params.className, 
                position: params.position,
                autoHide: params.autoHide,
                clickToHide: params.clickToHide
            }
        );
    }
    static hide(styleName){
        // styleName.trigger('notify-hide');
        styleName.closest('.notifyjs-wrapper').slideUp('slow', 'swing', () => styleName.closest(".notifyjs-wrapper").remove())
    }
}

class Trail {
    static log = async (params) => {
        // console.log(JSON.stringify({...params}))
        $.post('/trails.php?log',  { ...params })
        .then(resp => console.log(resp))
        .catch(error => console.error(error))
    }
    
    static get = async () => {
        pop('/trails.php?pop')
        .then(resp => console.log(resp))
        .catch(error => console.error(error))
    }
}

const popStoresToElm = params => {
    $(params.el).html(`<option value="">--- select ---</option>`).append(_.join(_.split(_.map(_.filter(params.allStores, as => as.store_id != (params.store_id)), store => (`<option value="${store.store_id}">${_.toUpper(store.store)}</option>`)), ','), ''))
}

async function pop(url, payLoad){
    // console.log("pop params: ", url)
    let resp = await (await fetch(url, payLoad)).json();
    $(`.tabulator .tabulator-footer .tabulator-paginator .tabulator-page[data-page="first"]`).html(`<i class="lni lni-chevron-left"></i><i class="lni lni-chevron-left"></i>`);
    $(`.tabulator .tabulator-footer .tabulator-paginator .tabulator-page[data-page="prev"]`).html(`<i class="lni lni-chevron-left"></i>`);
    $(`.tabulator .tabulator-footer .tabulator-paginator .tabulator-page[data-page="next"]`).html(`<i class="lni lni-chevron-right"></i>`);
    $(`.tabulator .tabulator-footer .tabulator-paginator .tabulator-page[data-page="last"]`).html(`<i class="lni lni-chevron-right"></i><i class="lni lni-chevron-right"></i>`);
    $(`.tabulator .tabulator-footer .tabulator-paginator label`).html(`#`);
    // console.log(resp)
    return resp;
}

const popCountries = async() => {
    let countries;
    await pop('../assets/plugins/countries-states-cities-database.json')
    // .then(countries => countries = _.map(countries, country => country.region.toLowerCase() == "africa"))
    .then(all_countries => countries = _.filter(all_countries, country => country.region.toLowerCase() == "africa"))
    .catch(err => console.error(err));
    return countries;
}

const calcVATDISCOUNTAMOUNT = (type, rate, bill) => he.decode(type) == '%' ? ((rate / 100) * bill): rate;

var TextEditor = params => new ysEditor({    
    // Editor wrapper
    wrapper: params.wrapper || '#custom_receipt_footer_text',    
    // Toolbar options
    // toolbar: [
    //   'undo', 'redo', 'bold', 'italic', 'underline',
    //   'strikethrough', 'h1', 'h2', 'h3', 'p', 'quote',
    //   'left', 'center', 'right', 'justify',
    //   'ol', 'ul', 'sub', 'sup',
    //   'removeformat'
    // ],
    toolbar: params.toolbar || [
        'bold', 'italic', 'underline', 'strikethrough'
    ],
    bottom: false,    
    // Content options
    height: params.height ?? 60,
    scroll: params.scroll ?? false,
    includeContent: true,    
    // Footer options
    footer: false,
});

const setPrintHeader = params => {
    params.table.options.printHeader = params.content;
},
PAYMENT_METHODS = [{id: 1, title: "Cash"}, {id: 2, title: "Mobile Pay"}, {id: 3, title: "POS"}, {id: 4, title: "Credit"}, {id: 5, title: "Debit"}, {id: 6, title: "Cheque"}, {id: 7, title: "Voucher"}, {id: 8, title: "Gift Card"}, {id: 9, title: "Paypal"}, {id: 10, title: "Other"}],
scrollToBottom = params => params.el.animate({ scrollTop: params.el.height() }, params.duration);

//define column header menu as column visibility toggle
const headerMenu = function(){
    let menu = [], columns = _.filter(this.getColumns(), col => col.getDefinition().visible != false && (col.getDefinition().title != '' && !_.isUndefined(col.getDefinition().title)));

    for(let column of columns){
        //create checkbox element using font awesome icons
        let icon = document.createElement("i"), label = document.createElement("span"), title = document.createElement("span");
            icon.classList.add("fa");
            icon.classList.add(column.isVisible() ? "fa-check-square" : "fa-square");

        title.textContent = " " + column.getDefinition().title;

        label.appendChild(icon);
        label.appendChild(title);

        //create menu item
        menu.push({
            label,
            action: e => {
                //prevent menu closing
                e.stopPropagation();

                //toggle current column visibility
                column.toggle();

                //change menu item icon
                if(column.isVisible()){
                    icon.classList.remove("fa-square");
                    icon.classList.add("fa-check-square");
                }else{
                    icon.classList.remove("fa-check-square");
                    icon.classList.add("fa-square");
                }
            }
        });
    }

    return menu;
},
headerFmt = params => `<small>| <span style="color: #777;">${params.value} ${params.value > 1 ? `${params.text} ${params.text != "" ? 's' : ''}` : params.text}</span></small>`

const extractStockProps = params => {
    // console.log("extractStockProps Params: ", params)
    // const { filter_currency_id, filter_currencies } = params
    // const{ base, exchange_rate: filter_exchange_rate } = _.find(filter_currencies, fc => fc.id == filter_currency_id)
    let uniqItemCurrs = []
    return _.filter(params.data, entry => {
        // if(params.store_id != ""){
            if(_.size(_.filter(JSON.parse(entry.stores), store => store.store_id == params.store_id && _.size(store.ppq) > 0))){
                const item_store = JSON.parse(entry.stores), store_idx = _.findIndex(item_store, store => store.store_id == params.store_id && _.size(store.ppq) > 0);
                // console.log(item_store[store_idx])
                const { currency_id, exchange_rate, factor } = item_store[store_idx];
                // _.indexOf(uniqItemCurrs, currency_id) < 1 ? uniqItemCurrs = [...uniqItemCurrs, currency_id] : ''
                // console.log({exchange_rate, filter_exchange_rate, uniqItemCurrs, f: _.indexOf(uniqItemCurrs, filter_currency_id)})
                entry.idx = store_idx;
                entry.active = item_store[store_idx].active;
                entry.qty = currency(item_store[store_idx].qty).value;
                entry.track = item_store[store_idx].track;
                entry.negative = item_store[store_idx].negative;
                entry.restock = item_store[store_idx].restock; 
                entry.tax_id = item_store[store_idx].tax_id;
                entry.ppq = item_store[store_idx].ppq; 
                entry.dim = _.maxBy(entry.ppq, entry => currency(entry.qty).value).qty;
                entry.title = `${entry.dim > 1 && entry.item.toUpperCase() + ' X ' + entry.dim || entry.item}`
                // console.log(entry.dim, entry.item)
                // entry.cp = !base ? currency_id != filter_currency_id ? _.indexOf(uniqItemCurrs, filter_currency_id) < 0 ? currency(entry.cp).multiply(currency(_.find(filter_currencies, fc => fc.id == currency_id).exchange_rate).multiply(filter_exchange_rate).value) : currency(entry.cp).divide(filter_exchange_rate).value : entry.cp : currency_id != filter_currency_id ? currency(entry.cp).multiply(exchange_rate).value : entry.cp
                entry.ucp = currency(ItemModel.ucp({item: entry})).value
                entry.cp = exchange_rate < 1 ? entry.cp : currency(entry.cp).multiply(exchange_rate || 1).value
                entry.xcp = currency(ItemModel.xcp({item: entry})).value
                entry.wp = currency(ItemModel.wp({item: entry})).value
                entry.wp_qty = currency(ItemModel.xwp({item: entry})).value
                entry.xwp = currency(ItemModel.xwp({item: entry})).value
                entry.mwp = currency(ItemModel.mwp({item: entry})).value
                entry.rp = currency(ItemModel.rp({item: entry})).value
                entry.xrp = currency(ItemModel.xrp({item: entry})).value
                entry.mrp = currency(ItemModel.mrp({item: entry})).value
                entry.mup = currency(entry.rp).subtract(entry.ucp).value
                entry.restock = entry.restock > 0 ? entry.restock : '';
                entry.expdate = entry.expdate ? moment(entry.expdate).format('MMM DD, YYYY') : '';
                return entry;
            }
        // }
    });
}

class MyProgressLoader {
    static load(params){
        const content = params?.content;
        myAlertifyDialog({
            name: 'loadingBills', 
            content: content || `
                <div class="d-grid justify-content-center" style="gap: 20px; align-items: center;">
                    <div class="spinner-grow text-body-tertiary specific-w-50 specific-h-50 mx-auto" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <span>Waiting for response...</spanpspan>
                </div>
            `,
            setup: {
                startMaximized: false,
                closable: false,
                resizable: false,
                // modal: false
            }
        }).resizeTo(100, 120)
    }
    static stop(){
        alertify.loadingBills().close();
    }
}

let expTimer = params => {
    let current = params.current, deadline = params.deadline, remain = params.remain,
        timer = params.timer,
        expAlert = params => alertify.alert("Subscription Reminder", params.msg || `<h1>You have <b style="color: red;">${remain} days</b> left on your subscription plan. <br/><br/>Please activate now.</h1>`)
        .set({
            // 'frameless': true,
            'closable': false,
            'closableByDimmer': false,  
            'label': 'Activate Now',  
            'onok': () => {
                window.open(`https://paystack.com/pay/ztgh1y8c--`, "_blank");
            },       
            onclose: () => { 
                sessionStorage.setItem('waiting', true);
                // Reset the timer
                timer = 0;
                // Re-trigger(show) Subscription Modal after every hour
                expTimer({timer: (60000 * (remain > 7 ? 60 : 1))});
            },
            ...params
        }),
        interval = setTimeout(() => {
            clearTimeout(interval);
            if(current < deadline && current > deadline.minus({months: 1})){
                expAlert({});
            }
            else if(current > deadline){
                expAlert({
                    msg: `<h1 style="text-align: center;"><img src="/assets/img/expired.png" alt="Expired Photo" width="350px" /></p><span><b style="color: red;">Expired!</b></p><small style="font-size: 18px;">Your license is expired.</small></p><small style="font-size: 18px;">Please activate now.</small></span></h1>`,
                    // 'frameless': true,                        
                    onclosing: () => {
                        return false;
                    },
                    onclose: () => { 
                        sessionStorage.setItem('waiting', true);
                        // Reset the timer
                        timer = 0;
                        // Re-trigger(show) Subscription Modal after every hour
                        expTimer({timer: (60000 * (remain > 7 ? 60  : 1))});
                    },
                });
            }
        }, timer);
}

const caps = e => e.getModifierState && e.getModifierState('CapsLock')

// SUBSCRIPTION REMINDER    
// let current = DateTime.now().startOf('day'), deadline = DateTime.fromISO("2022-06-15"), remain = deadline.diff(current, 'days').as('days');   
// location.pathname != "/" && (sessionStorage.getItem('waiting') && expTimer({timer: 1000, current, deadline, remain}));

// let allStores = JSON.parse(companyProfile[0].stores),
//     myStores = _.filter(allStores, as => _.indexOf(JSON.parse(activeUser.stores), as.store_id) > -1 && as)

export {
    // allStores,
    // myStores,
    Trail,
    localeEn,
    MAPBOX_ACCESS_TOKEN,
    validateEmail,
    expTimer,
    currency,
    MyProgressLoader,
    CEDIS,
    activeUser,
    appSounds,
    SystemPrefs,
    myTransCodePrefix,
    Swiper,
    thousandsSeperator,
    Notif,
    pop,
    popCountries,
    calcVATDISCOUNTAMOUNT,
    TextEditor,
    setPrintHeader,
    QIHRF,
    PAYMENT_METHODS,
    scrollToBottom,
    headerMenu,
    headerFmt,
    extractStockProps,
    popStoresToElm,
    ENDPOINTS,
    caps
}